000100 IDENTIFICATION DIVISION.
000200 PROGRAM-ID. MQ02.
000300 DATA DIVISION.
000400 WORKING-STORAGE SECTION.
000500 01 MY-MQ-CONSTANTS.
000600    COPY CMQV.
000700 01 OBJECT-DESCRIPTOR.
000800    COPY CMQODV.
000900 01 MESSAGE-DESCRIPTOR.
001000    COPY CMQMDV.
001100 01 PMOPTIONS.
001200    COPY CMQPMOV.
001300 01 QM-NAME                    PIC X(48) VALUE SPACES.
001400 01 HCONN                      PIC S9(9) BINARY.
001500 01 Q-HANDLE                   PIC S9(9) BINARY.
001600 01 OPTIONS                    PIC S9(9) BINARY.
001700 01 COMPLETION-CODE            PIC S9(9) BINARY.
001800 01 OPEN-CODE                  PIC S9(9) BINARY.
001900 01 CON-REASON                 PIC S9(9) BINARY.
002000 01 REASON                     PIC S9(9) BINARY.
002100 01 BUFFER                     PIC X(60).
002200 01 BUFFER-LENGTH              PIC S9(9) BINARY.
002300 01 TARGET-QUEUE               PIC X(48).
002400 01  WS-TEXT.
002500      05 TEXT-1  PIC X(63).
002600      05 TEXT-2  PIC S99999999 SIGN LEADING SEPARATE.
002700 01  WS-TEXT-LEN  PIC X(8)  COMP-5  VALUE 72.
002800*----------------------------------------------------------------*
002900*---------------     <<     LINKAGE       >>      ---------------*
003000*----------------------------------------------------------------*
003100 LINKAGE SECTION.                                                 
003200 01  DFHCOMMAREA.
003300     02  MQVALUE                PIC X(20).
003400*----------------------------------------------------------------*
003500*---------------     <<     PROCEDURE     >>      ---------------*
003600*----------------------------------------------------------------*
003700 PROCEDURE DIVISION.
003800 OPENS.
003900*--- MQ OPEN    
004000     MOVE 'QUEUE1' TO MQOD-OBJECTNAME.
004100     ADD MQOO-OUTPUT MQOO-FAIL-IF-QUIESCING
004200               GIVING OPTIONS.
004300     CALL 'MQOPEN'
004400      USING HCONN, OBJECT-DESCRIPTOR,
004500      OPTIONS, Q-HANDLE,
004600      OPEN-CODE, REASON.
004700
004800     IF REASON IS NOT EQUAL TO MQRC-NONE
004900       MOVE 'MQOPEN ended with reason code ' TO TEXT-1
005000       MOVE  REASON TO TEXT-2
005100       EXEC CICS WRITE OPERATOR TEXT(WS-TEXT)
005200                TEXTLENGTH(WS-TEXT-LEN) END-EXEC
005300     END-IF.
005400
005500     IF OPEN-CODE IS EQUAL TO MQCC-FAILED
005600       MOVE 'unable to open target queue for output' TO TEXT-1
005700       MOVE REASON TO TEXT-2
005800       EXEC CICS WRITE OPERATOR TEXT(WS-TEXT)
005900                TEXTLENGTH(WS-TEXT-LEN) END-EXEC
006000       GOBACK
006100     END-IF.
006200
006300*--- MQ PUT    
006400 PUTS.
006500     MOVE MQPMO-NO-SYNCPOINT TO MQPMO-OPTIONS.
006600     MOVE 60 to BUFFER-LENGTH.
006700     MOVE MQVALUE TO BUFFER.
006800     CALL 'MQPUT'
006900      USING HCONN, Q-HANDLE,
007000      MESSAGE-DESCRIPTOR, PMOPTIONS,
007100      BUFFER-LENGTH, BUFFER,
007200      COMPLETION-CODE, REASON.
007300
007400     IF REASON IS NOT EQUAL TO MQRC-NONE
007500       MOVE 'MQPUT ended with reason code ' TO TEXT-1
007600       MOVE REASON TO TEXT-2
007700       EXEC CICS WRITE OPERATOR TEXT(WS-TEXT)
007800                TEXTLENGTH(WS-TEXT-LEN) END-EXEC
007900     END-IF.
008000
008100*--- MQ CLOSE    
008200 CLOSES.
008300     MOVE MQCO-NONE TO OPTIONS.
008400     CALL 'MQCLOSE'
008500      USING HCONN, Q-HANDLE, OPTIONS,
008600      COMPLETION-CODE, REASON.
008700
008800     IF REASON IS NOT EQUAL TO MQRC-NONE
008900       MOVE 'MQCLOSE ended with reason code ' TO TEXT-1
009000       MOVE REASON TO TEXT-2
009100       EXEC CICS WRITE OPERATOR TEXT(WS-TEXT)
009200                TEXTLENGTH(WS-TEXT-LEN) END-EXEC
009300     END-IF.
009400
009500     GOBACK.