       IDENTIFICATION DIVISION.
       PROGRAM-ID. 'MQMSGGET'.
      ****************************************************************
       DATA DIVISION.
       WORKING-STORAGE SECTION.
      *
      **  Declare MQI structures needed
      * MQI named constants
       01 MY-MQ-CONSTANTS.
          COPY CMQV.
      * Object Descriptor
       01 OBJECT-DESCRIPTOR.
          COPY CMQODV.
      * Message Descriptor
       01 MESSAGE-DESCRIPTOR.
          COPY CMQMDV.
      * Get message options
       01 GMOPTIONS.
          COPY CMQGMOV.
      ** note, sample uses defaults where it can
       01 QM-NAME                    PIC X(48) VALUE SPACES.
       01 HCONN                      PIC S9(9) BINARY.
       01 Q-HANDLE                   PIC S9(9) BINARY.
       01 OPTIONS                    PIC S9(9) BINARY.
       01 COMPLETION-CODE            PIC S9(9) BINARY.
       01 OPEN-CODE                  PIC S9(9) BINARY.
       01 CON-REASON                 PIC S9(9) BINARY.
       01 REASON                     PIC S9(9) BINARY.
       01 BUFFER                     PIC X(64).
       01 BUFFER-LENGTH              PIC S9(9) BINARY.
       01 DATA-LENGTH                PIC S9(9) BINARY.
       01 SOURCE-QUEUE               PIC X(48).
       
       01  WRITE-OPE.
           03  TEXT1  PIC X(20).
           03  TEXT2  PIC X(20).
       01 MQVALUE                    PIC X(20).

      ****************************************************************
       PROCEDURE DIVISION.
       P0.
           MOVE 'QMA' TO QM-NAME.
           MOVE 'QUEUE1' TO SOURCE-QUEUE.

      ****************************************************************
      *                                                              *
      *   Open the message queue (and fail if MQM is quiescing)      *
      *                                                              *
      ****************************************************************
       OPENS.
           MOVE 'QUEUE1' TO MQOD-OBJECTNAME.
           ADD MQOO-INPUT-AS-Q-DEF MQOO-FAIL-IF-QUIESCING
                     GIVING OPTIONS.
           CALL 'MQOPEN'
            USING HCONN, OBJECT-DESCRIPTOR,
            OPTIONS, Q-HANDLE,
            OPEN-CODE, REASON.

      *      report reason, if any; stop if failed
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQOPEN ended with reason code ' REASON
             END-IF.

           IF OPEN-CODE IS EQUAL TO MQCC-FAILED
             DISPLAY 'unable to open queue for input'
             MOVE REASON TO RETURN-CODE
             GOBACK
             END-IF.

      ****************************************************************
      *                                                              *
      *   Get messages from the message queue                        *
      *                                                              *
      ****************************************************************
       GETS.
           MOVE OPEN-CODE TO COMPLETION-CODE.
           PERFORM GETR THRU DISPR WITH TEST BEFORE
             UNTIL COMPLETION-CODE IS EQUAL TO MQCC-FAILED.

      ****************************************************************
      *                                                              *
      *   Close the source queue                                     *
      *                                                              *
      ****************************************************************
       CLOSES.
           MOVE MQCO-NONE TO OPTIONS.
           CALL 'MQCLOSE'
            USING HCONN, Q-HANDLE, OPTIONS,
            COMPLETION-CODE, REASON.

      *      report reason, if any
           IF REASON IS NOT EQUAL TO MQRC-NONE
             DISPLAY 'MQCLOSE ended with reason code ' REASON
             END-IF.

      ****************************************************************
      *                                                              *
      *  Disconnect from queue manager (if not previously connected) *
      *                                                              *
      ****************************************************************
       DISCS.
           IF CON-REASON IS NOT EQUAL TO MQRC-ALREADY-CONNECTED
             CALL 'MQDISC'
              USING HCONN, COMPLETION-CODE, REASON

      *      report reason, if any
             IF REASON IS NOT EQUAL TO MQRC-NONE
               DISPLAY 'MQDISC ended with reason code ' REASON
             END-IF
           END-IF.

       OVER.
      ** indicate that sample program has finished
           MOVE ZERO TO RETURN-CODE.
           GOBACK.

      ****************************************************************
      *                                                              *
      *   Get one message                                            *
      *                                                              *
      *   In order to read the messages in sequence, MSGID and       *
      *   CORRELID must have the default value.  MQGET sets them     *
      *   to the values for the message it returns, so re-initialise *
      *   them each time                                             *
      *                                                              *
      ****************************************************************
       GETR.
           MOVE MQMI-NONE TO MQMD-MSGID.
           MOVE MQCI-NONE TO MQMD-CORRELID.
           MOVE SPACES TO BUFFER.
           ADD MQGMO-WAIT MQGMO-NO-SYNCPOINT GIVING MQGMO-OPTIONS.
      *** ~bw
           MOVE 10000 TO MQGMO-WAITINTERVAL.
           MOVE 64 to BUFFER-LENGTH.

           CALL 'MQGET'
            USING HCONN, Q-HANDLE,
            MESSAGE-DESCRIPTOR, GMOPTIONS,
            BUFFER-LENGTH, BUFFER, DATA-LENGTH,
            COMPLETION-CODE, REASON.

      ****************************************************************
      *                                                              *
      *   Display message received                                   *
      *                                                              *
      ****************************************************************
       DISPM.
           IF COMPLETION-CODE IS NOT EQUAL TO MQCC-FAILED
              MOVE 'MQ message is : ' TO TEXT1
              MOVE BUFFER TO TEXT2
              EXEC CICS WRITE OPERATOR TEXT(WRITE-OPE)
                   TEXTLENGTH(40) 
              END-EXEC
           END-IF.

      ****************************************************************
      *                                                              *
      *   Insert Data to DB2                                         *
      *                                                              *
      ****************************************************************

           IF BUFFER IS NOT EQUAL TO SPACE
              MOVE BUFFER TO MQVALUE
      *--- bZ[W𗘗pvǑĂяoӏ       
      *         EXEC CICS LINK PROGRAM('XXXXX')
      *              COMMAREA(MQVALUE) 
      *              LENGTH(20) 
      *         END-EXEC
           END-IF.

      ****************************************************************
      *                                                              *
      *  Report reason, if any                                       *
      *                                                              *
      ****************************************************************
       DISPR.
           IF REASON IS NOT EQUAL TO MQRC-NONE
             IF REASON IS EQUAL TO MQRC-NO-MSG-AVAILABLE
                MOVE 'MQ no more messages' TO TEXT1
                MOVE SPACE TO TEXT2
                EXEC CICS WRITE OPERATOR TEXT(WRITE-OPE)
                     TEXTLENGTH(40) 
                END-EXEC
             ELSE
               DISPLAY 'MQGET ended with reason code ' REASON
             END-IF
           END-IF.

      ****************************************************************
      *                                                              *
      * END OF MQGETWRT                                              *
      *                                                              *
      ****************************************************************
