       IDENTIFICATION DIVISION.
       PROGRAM-ID. DEMO001T.
      *REMARKS.
      *
      * Copyright (c) Micro Focus 1991-2012. All rights reserved. The 
      * software and information contained herein are proprietary to,
      * and comprise valuable trade secrets of, Micro Focus , which 
      * intends to preserve as trade secrets such software and 
      * information. This software is an unpublished copyright of 
      * Micro Focus and may not be used, copied, transmitted, or 
      * stored in any manner.  This software and information or any 
      * other copies thereof may not be provided or otherwise made 
      * available to any other person.
      *
      * This program is invoked by tran code "MFDEMO".
      * This loads/maintains table file data in IMS database DEMO03DD.
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.
       WORKING-STORAGE SECTION.
       77  RGHTJUST       PIC X(08) VALUE 'RGHTJUST'.
       77  OTDEMO90       PIC X(08) VALUE 'OTDEMO90'.
       77  OTDEMO91       PIC X(08) VALUE 'OTDEMO91'.
       77  OTDEMO92       PIC X(08) VALUE 'OTDEMO92'.
       77  TBL-PRINTER    PIC X(08) VALUE '      '.
       77  ABEND          PIC X(08) VALUE 'ABEND'.
       77  KEEP-STATUS1   PIC X.
       77  LOOK-STATUS1   PIC X.
       77  EDIT-SWITCH    PIC X.
       77  DATE-SW        PIC X.
       77  REPL-SW        PIC X.
       77  CHANGE-ADD-SW  PIC X.
       77  EOP-SW         PIC X.
       77  LENGTH-ERROR   PIC X.
       77  FIRST-TIME     PIC X.
       77  FIRST-INSERT   PIC X.
       77  DATA-PRESENT   PIC X.
       77  SCREEN2-AGAIN  PIC X.
       77  SCREEN2-FULL   PIC X.
       77  DUMVAL         PIC X.
       77  CRT-LENGTH     PIC S9(4) COMP VALUE +1800.
       77  LINE-CNT       PIC S9(4) COMP VALUE ZERO.
       77  SCREEN-CNT     PIC S9(4) COMP VALUE ZERO.
       77  J              PIC S9(4) COMP VALUE ZERO.
       77  ISUB           PIC S9(4) COMP VALUE ZERO.
       77  OSUB           PIC S9(4) COMP VALUE ZERO.
       77  PSUB           PIC S9(4) COMP VALUE ZERO.
       77  WSUB           PIC S9(4) COMP VALUE ZERO.
       77  HSUB           PIC S9(4) COMP VALUE ZERO.
      ******************************************************************
      * MFS INTERFACE AREA FOR MOD DEFINITION - PROGRAM DEMO001T.
      ******************************************************************
       01  DEMO90-LTH      PIC S9(04) COMP VALUE 445.
       01  DEMO91-LTH      PIC S9(04) COMP VALUE 195.
       01  DEMO92-LTH      PIC S9(04) COMP VALUE 1405.
       01  DC001TIO.
           04  LL01-IN   PIC S9(4) COMP.
           04  Z001      PIC X(01).
           04  Z0012     PIC X(01).
           04  TIOAIO    PIC X(3000).
      ******************************************************************
      ** DEMO92 ********************************************************
      ***************  DEMO92  SCREEN LAYOUT  **************************
      ******************************************************************
      ******************************************************************
       01  DEMO92-SCREEN.
           03  DEMO92-DATA.
               05 DEMO92-TRANSCODE       PIC X(79).
               05 DEMO92-PROGRAM-NO      PIC X(08).
               05 DEMO92-TYPEC           PIC X(01).
               05 DEMO92-TYPEA           PIC X(01).
               05 DEMO92-TYPE            PIC X(07).
               05 DEMO92-TABLE-IDC       PIC X(01).
               05 DEMO92-TABLE-IDA       PIC X(01).
               05 DEMO92-TABLE-ID        PIC X(32).
               05 DEMO92-ERR-MSG         PIC X(35).
               05 DEMO92-LAST-KEYC       PIC X(01).
               05 DEMO92-LAST-KEYA       PIC X(01).
               05 DEMO92-LAST-KEY        PIC X(20).
               05 DEMO92-PROCESS-IND     PIC X(01).
               05 DEMO92-STATUS          PIC X(01).
               05 DEMO92-ISRT-ROOT       PIC X(01).
               05 DEMO92-EXPAND          PIC X(13).
               05 DEMO92-DESCC           PIC X(01).
               05 DEMO92-DESCA           PIC X(01).
               05 DEMO92-DESC            PIC X(50).
               05 DEMO92-ELE-KEY-CNTC    PIC X(01).
               05 DEMO92-ELE-KEY-CNTA    PIC X(01).
               05 DEMO92-ELE-KEY-CNTX    PIC X(02).
               05 DEMO92-ELE-KEY-CNT REDEFINES DEMO92-ELE-KEY-CNTX
                                         PIC 9(02).
               05 DEMO92-ELE-CHRC        PIC X(01).
               05 DEMO92-ELE-CHRA        PIC X(01).
               05 DEMO92-ELE-CHRX        PIC X(02).
               05 DEMO92-ELE-CHR REDEFINES DEMO92-ELE-CHRX
                                         PIC 9(02).
               05 DEMO92-ACT-DATEC       PIC X(01).
               05 DEMO92-ACT-DATEA       PIC X(01).
               05 DEMO92-ACT-DATE        PIC X(08).
               05 DEMO92-TBL-PROTC       PIC X(01).
               05 DEMO92-TBL-PROTA       PIC X(01).
               05 DEMO92-TBL-PROT        PIC X(01).
               05 DEMO92-TBL-PSWC        PIC X(01).
               05 DEMO92-TBL-PSWA        PIC X(01).
               05 DEMO92-TBL-PSW         PIC X(08).
               05 DEMO92-ELE-NUM-KEYC    PIC X(01).
               05 DEMO92-ELE-NUM-KEYA    PIC X(01).
               05 DEMO92-ELE-NUM-KEY     PIC X(01).
               05 DEMO92-ELE-NUM-VALC    PIC X(01).
               05 DEMO92-ELE-NUM-VALA    PIC X(01).
               05 DEMO92-ELE-NUM-VAL     PIC X(01).
           03  DEMO92-MATRIX.
               05  CRT-LINE OCCURS 14 TIMES.
                   07  DEMO92-FUNCC      PIC X(01).
                   07  DEMO92-FUNCA      PIC X(01).
                   07  DEMO92-FUNC       PIC X(01).
                   07  DEMO92-ELE-KEYC   PIC X(01).
                   07  DEMO92-ELE-KEYA   PIC X(01).
                   07  DEMO92-ELE-KEY    PIC X(20).
                   07  DEMO92-ELE-DATAC  PIC X(01).
                   07  DEMO92-ELE-DATAA  PIC X(01).
                   07  DEMO92-ELE-DATA   PIC X(50).
           03  DEMO92-NEXT-FUNC.
               05  DEMO92-RETURNC        PIC X(01).
               05  DEMO92-RETURNA        PIC X(01).
               05  DEMO92-RETURN         PIC X(01).
               05  DEMO92-CONTC          PIC X(01).
               05  DEMO92-CONTA          PIC X(01).
               05  DEMO92-CONT           PIC X(01).
               05  DEMO92-ABORTC         PIC X(01).
               05  DEMO92-ABORTA         PIC X(01).
               05  DEMO92-ABORT          PIC X(01).
               05  DEMO92-NEXT-KEYC      PIC X(01).
               05  DEMO92-NEXT-KEYA      PIC X(01).
               05  DEMO92-NEXT-KEY       PIC X(20).
      ******************************************************************
      ** DEMO91 ********************************************************
      ***************  DEMO91  SCREEN LAYOUT  **************************
      ******************************************************************
      ******************************************************************
       01  DEMO91-SCREEN.
           03  DEMO91-DATA.
               05 DEMO91-TRANSCODE   PIC X(79).
               05 DEMO91-PROGRAM-NO  PIC X(08).
               05 DEMO91-ERR-MSG     PIC X(35).
               05 DEMO91-LTERM       PIC X(08).
               05 DEMO91-USERID      PIC X(08).
               05 DEMO91-GROUPID     PIC X(08).
               05 DEMO91-FUNCTIONC   PIC X(01).
               05 DEMO91-FUNCTIONA   PIC X(01).
               05 DEMO91-FUNCTION    PIC X(01).
               05 DEMO91-TABLE-IDC   PIC X(01).
               05 DEMO91-TABLE-IDA   PIC X(01).
               05 DEMO91-TABLE-ID    PIC X(32).
               05 DEMO91-ELESC       PIC X(01).
               05 DEMO91-ELESA       PIC X(01).
               05 DEMO91-ELES        PIC X(20).
               05 DEMO91-PASSWORDC   PIC X(01).
               05 DEMO91-PASSWORDA   PIC X(01).
               05 DEMO91-PASSWORD    PIC X(08).
       66  DEMO91-REST RENAMES DEMO91-PROGRAM-NO THRU DEMO91-PASSWORD.
       01  COMMON-END-SCREEN.
           03  ENDING-TRANCODEC    PIC X(01) VALUE X'C0'.
           03  ENDING-TRANCODEA    PIC X(01) VALUE X'40'.
           03  ENDING-TRANCODE     PIC X(79) VALUE SPACES.
           03  END-LINE1           PIC X(60) VALUE
           '      * * * * MICRO FOCUS SUPPORT SYSTEMS * * * *'.
           03  END-LINE2           PIC X(60) VALUE ' '.
           03  END-LINE3           PIC X(60) VALUE
           '            TRANCODE - MFDEMO - ENDED   '.
           03  END-LINE4           PIC X(60) VALUE ' '.
           03  END-LINE5           PIC X(60) VALUE ' '.
           03  END-LINE6           PIC X(60) VALUE ' '.
       01  FILLER3                 PIC X(4000).
       01  BUBBLE-UP-AREA.
           03  S-DEMO92-MATRIX.
               05  S-CRT-LINE OCCURS 14 TIMES.
                   07  S-M2-FUNCC      PIC X(01).
                   07  S-M2-FUNCA      PIC X(01).
                   07  S-M2-FUNC       PIC X(01).
                   07  S-M2-ELE-KEYC   PIC X(01).
                   07  S-M2-ELE-KEYA   PIC X(01).
                   07  S-M2-ELE-KEY    PIC X(20).
                   07  S-M2-ELE-DATAC  PIC X(01).
                   07  S-M2-ELE-DATAA  PIC X(01).
                   07  S-M2-ELE-DATA   PIC X(50).
      ******************************************************************
      ****** IMS DATABASE SEGMENT DEFINITION AREA - PROGRAM DEMO001T.***
      ******************************************************************
      **********      TABLE DATA BASE HEADER       *********************
      **********           144 BYTES               *********************
      ******************************************************************
       01  DEMOHDRS.
           03  DEMOHDRS-KEY-GROUP.
               05  DEMOHDRS-KEY-SEQ          PIC X(08) VALUE LOW-VALUES.
               05  DEMOHDRS-KEY              PIC X(32).
           03  DEMOHDRS-TABLE-DESCRIPTOR.
               05  FILLER                    PIC X(50).
           03  DEMOHDRS-EXPANSION            PIC X(29).
           03  DEMOHDRS-TABLE-DELETE-IND     PIC X(01) VALUE SPACE.
           03  DEMOHDRS-TABLE-CHARACTERISTICS.
               05  DEMOHDRS-KEY-CHAR-CNT     PIC S9(3) COMP-3.
               05  DEMOHDRS-ELE-CHAR-CNT     PIC S9(3) COMP-3.
               05  DEMOHDRS-MAX-ELE-CNT      PIC S9(3) COMP-3 VALUE +0.
               05  DEMOHDRS-PASSWORD-PROT    PIC X(01) VALUE 'N'.
               05  DEMOHDRS-PASSWORD         PIC X(08) VALUE SPACES.
               05  DEMOHDRS-NUMERIC-KEY      PIC X(01) VALUE '0'.
               05  DEMOHDRS-NUMERIC-ELE      PIC X(01) VALUE '0'.
           03  DEMOHDRS-LAST-ACT-DATE        PIC 9(6) COMP-3.
           03  FILLER                        PIC X(03).
      ******************************************************************
      * DEMOELES *******************************************************
      **************  TABLE DATA BASE DETAIL       *********************
      *************        224 BYTES                                ****
      ******************************************************************
       01  DEMOELES.
           03  DEMOELES-KEY-GROUP.
               05  DEMOELES-KEY-EXPANSION    PIC X(10) VALUE LOW-VALUES.
               05  DEMOELES-KEY              PIC X(20).
           03  DEMOELES-ELE-DATA.
               05  FILLER                    PIC X(133) VALUE SPACES.
           03  DEMOELES-TABLE-NUMERIC.
               05  FILLER                    PIC S9(15) COMP-3 VALUE +0.
           03  DEMOELES-EXPANSION.
               05  FILLER                    PIC X(53).
      ****** SSA FOR SEGMENT DEMOORDS - TABLE HEADER SEGMENT ***********
       01  SSA-HDRS.
           03  HDRS-SEGNAME        PIC X(08) VALUE 'DEMOHDRS'.
           03  HDRS-COM            PIC X     VALUE '*'.
           03  HDRS-COM1           PIC X     VALUE '-'.
           03  HDRS-COM2           PIC X     VALUE '-'.
           03  HDRS-QUALIFY        PIC X     VALUE '('.
           03  HDRS-KEYFLD         PIC X(8)  VALUE 'SEQFIELD'.
           03  HDRS-RLO1           PIC XX    VALUE ' ='.
           03  HDRS-FLDVALUE0.
               05  HDRS-FLDVALUE2  PIC X(08) VALUE LOW-VALUES.
               05  HDRS-FLDVALUE1  PIC X(32).
           03  HDRS-ENDQUALIFY PIC X     VALUE ')'.
      ****** SSA FOR SEGMENT DEMOELES - ELEMENTARY SEGMENT *************
       01  SSA-ELES.
           03  ELES-SEGNAME    PIC X(08) VALUE 'DEMOELES'.
           03  ELES-COM        PIC X     VALUE '*'.
           03  ELES-COM1       PIC X     VALUE '-'.
           03  ELES-COM2       PIC X     VALUE '-'.
           03  ELES-QUALIFY    PIC X     VALUE '('.
           03  ELES-KEYFLD     PIC X(8)  VALUE 'SEQFIELD'.
           03  ELES-RLO1       PIC XX    VALUE ' ='.
           03  ELES-FLDVALUE0.
               05  ELES-FLDVALUE2  PIC X(10) VALUE LOW-VALUES.
               05  ELES-FLDVALUE1  PIC X(20).
           03  ELES-ENDQUALIFY PIC X     VALUE ')'.
      *****PROGRAM WORK AREAS*************************************
       01  IMS-FUNCTIONS.
           03  GU                      PIC X(4)      VALUE 'GU'.
           03  GN                      PIC X(4)      VALUE 'GN'.
           03  GNP                     PIC X(4)      VALUE 'GNP'.
           03  ISRT                    PIC X(4)      VALUE 'ISRT'.
           03  GHNP                    PIC X(4)      VALUE 'GHNP'.
           03  REPL                    PIC X(4)      VALUE 'REPL'.
           03  DLET                    PIC X(4)      VALUE 'DLET'.
           03  GHN                     PIC X(4)      VALUE 'GHN'.
           03  CHNG                    PIC X(4)      VALUE 'CHNG'.
           03  PURG                    PIC X(4)      VALUE 'PURG'.
           03  GHU                     PIC X(4)      VALUE 'GHU '.
           03  ROLB                    PIC X(4)      VALUE 'ROLB'.
       01  IMS-RETURN-CODES.
           03  BB                      PIC XX        VALUE '  '.
           03  GE                      PIC XX        VALUE 'GE'.
           03  GB                      PIC XX        VALUE 'GB'.
           03  II                      PIC XX        VALUE 'II'.
           03  AI                      PIC XX        VALUE 'AI'.
           03  QC                      PIC XX        VALUE 'QC'.
           03  QD                      PIC XX        VALUE 'QD'.
      *01  IMS-ATTRIBUTES-PRINT.
      *    03  UMDAN                   PIC X VALUE 'A'.
      *    03  UMDAD                   PIC X VALUE 'E'.
      *    03  UMDAH                   PIC X VALUE 'I'.
      *    03  UMDNH                   PIC X VALUE 'R'.
      *    03  PNMDD                   PIC X VALUE 'U'.
      *    03  PMDDD                   PIC X VALUE 'V'.
      *    03  PMDAN                   PIC X VALUE '3'.
      *    03  PNMDH                   PIC X VALUE 'Y'.
      *    03  CURSORPOS               PIC X VALUE '{'.
       01  IMS-ATTRIBUTES-HEX.
           03  UMDAN                   PIC X VALUE X'C1'.
           03  UMDAD                   PIC X VALUE X'C5'.
           03  UMDAH                   PIC X VALUE X'C9'.
           03  UMDNH                   PIC X VALUE X'D9'.
           03  PNMDD                   PIC X VALUE X'E4'.
           03  PMDDD                   PIC X VALUE X'E5'.
           03  PMDAN                   PIC X VALUE X'F1'.
           03  PNMDH                   PIC X VALUE X'E8'.
           03  CURSORPOS               PIC X VALUE X'C0'.
       01  PROGRAM-FIELDS.
           03  MSS-WORK-AREA.
               05  MSS-IN-LENGTH PIC S9(8) VALUE ZERO COMP.
               05  MSS-RETURN        PIC X VALUE 'X'.
           03  CURR-YMD.
               05  CURR-YMD-YY     PIC XX.
               05  CURR-YMD-MM     PIC XX.
               05  CURR-YMD-DD     PIC XX.
           03  CURR-YMD9  REDEFINES CURR-YMD PIC 9(6).
           03  DATE-YMD.
               05  DATE-YMD-YY     PIC XX.
               05  DATE-YMD-MM     PIC XX.
               05  DATE-YMD-DD     PIC XX.
           03  DATE-YMD9  REDEFINES DATE-YMD PIC 9(6).
           03  GREG-DATE.
               05  GREG-MM         PIC XX.
               05  FILLER          PIC X   VALUE '/'.
               05  GREG-DD         PIC XX.
               05  FILLER          PIC X   VALUE '/'.
               05  GREG-YY         PIC XX.
           03  9000-ABEND-CODE     PIC 9(6).
           03  GROUP-KEY-AREA      PIC X(50).
           03  FILLER REDEFINES GROUP-KEY-AREA.
               05  KEY-MATRIX OCCURS 50 TIMES PIC X(01).
           03  ERROR-MESSAGES.
               05  FILLER PIC X(35) VALUE
                   'NOT NUMERIC'.
               05  FILLER PIC X(35) VALUE
                   'INVALID VALUE'.
               05  FILLER PIC X(35) VALUE
                   'FIELD IS TOO LONG'.
               05  FILLER PIC X(35) VALUE
                   'FIELD REQUIRES INPUT OF DATA'.
               05  FILLER PIC X(35) VALUE
                   'RECORD NOT FOUND ON FILE'.
               05  FILLER PIC X(35) VALUE
                   'RECORD ALREADY EXISTS ON FILE'.
               05  FILLER PIC X(35) VALUE
                   'TOO SMALL MUST BE > THAN PREVIOUS'.
               05  FILLER PIC X(35) VALUE
                   'PUT "D" IN RETURN TO CONFIRM DELETE'.
               05  FILLER PIC X(35) VALUE
                   'PASSWORD IS INVALID'.
               05  FILLER PIC X(35) VALUE
                   'PRINTER ID INVALID'.
               05  FILLER PIC X(35) VALUE
                   'IMS LTERM ID ERROR'.
           03  FILLER REDEFINES ERROR-MESSAGES.
               05  ERROR-MESSAGE OCCURS 11 TIMES PIC X(35).
       LINKAGE SECTION.
       01  PCB-LT.
           02  PCBNAME         PIC X(8).
           02  FILLER          PIC X(2).
           02  PCBSTAT         PIC X(2).
           02  PCBDATE         PIC 9(7)    COMP-3.
           02  PCBTIME         PIC 9(7)    COMP-3.
           02  PCBINSEQ        PIC S9(3)   COMP.
           02  FILLER          PIC X(2).
           02  PCBMODNM        PIC X(8).
           02  PCBUSERID       PIC X(8).
           02  PCBGROUPID      PIC X(8).
       01  ALT-PCB.
           03  ALT-PCBNAME              PIC X(8).
           03  FILLER                   PIC XX.
           03  ALT-STATUS               PIC XX.
           03  ALT-DATE                 PIC S9(7) COMP-3.
           03  ALT-TIME                 PIC S9(7) COMP-3.
           03  ALT-SEQNO                PIC S9(3) COMP.
           03  FILLER                   PIC XX.
           03  ALT-MODNAME              PIC X(8).
       01  DEMO-PCB.
           03  DEMO-DBD-NAME   PIC X(08).
           03  DEMO-LEVEL-NO   PIC XX.
           03  DEMO-STATUS     PIC XX.
           03  DEMO-PROCOPTS   PIC XXXX.
           03  DEMO-RESVD-DLI  PIC XXXX.
           03  DEMO-SEGMENT    PIC X(08).
           03  DEMO-FILLER     PIC X(8).
           03  DEMO-KEYFEEDBCK PIC X(100).

       PROCEDURE DIVISION   USING PCB-LT
                                  ALT-PCB
                                  DEMO-PCB.
           ENTRY 'DLITCBL'  USING PCB-LT
                                  ALT-PCB
                                  DEMO-PCB.
           MOVE SPACES         TO DEMO91-PROGRAM-NO.
           PERFORM C-010-INITIALIZE  THRU C-010-EXIT.
           PERFORM C-020-GET-MESSAGE THRU C-020-EXIT.
           PERFORM A-010-MAINLINE    THRU A-010-EXIT
               UNTIL (PCBSTAT NOT = BB).
           GOBACK.

       A-010-MAINLINE.
           IF DEMO91-PROGRAM-NO NOT = 'OTDEMO91' AND NOT = 'OTDEMO92'
               MOVE '1' TO FIRST-TIME
               MOVE 'OTDEMO91' TO DEMO91-PROGRAM-NO
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
           ELSE
               PERFORM A-030-PROCESS-TRAN THRU A-030-EXIT.
           PERFORM C-010-INITIALIZE  THRU C-010-EXIT.
           PERFORM C-020-GET-MESSAGE THRU C-020-EXIT.
       A-010-EXIT.
           EXIT.

       A-020-FIRST-TIME.
      *** SEND BACK INITIAL DEMO91 SCREEN (MENU)
           IF FIRST-TIME = '1'
               MOVE 0 TO FIRST-TIME
               PERFORM C-021-FORMAT-NULL-SCREEN THRU C-021-EXIT
               MOVE CURSORPOS TO DEMO91-FUNCTIONC.
           IF HSUB NOT = 0
               MOVE ERROR-MESSAGE (HSUB) TO DEMO91-ERR-MSG
           ELSE
               MOVE SPACES TO DEMO91-ERR-MSG.
           MOVE 'OTDEMO91' TO DEMO91-PROGRAM-NO.
           MOVE PCBNAME    TO DEMO91-LTERM.
           MOVE PCBUSERID  TO DEMO91-USERID.
           MOVE PCBGROUPID TO DEMO91-GROUPID.
           MOVE DEMO91-SCREEN TO TIOAIO.
           MOVE DEMO91-LTH    TO LL01-IN.
           CALL 'CBLTDLI' USING
               ISRT
               PCB-LT
               DC001TIO
               OTDEMO91.
            IF PCBSTAT = BB
                 NEXT SENTENCE
            ELSE
                 MOVE 3505 TO 9000-ABEND-CODE
                 PERFORM C-099-ABEND THRU C-099-EXIT.
       A-020-EXIT.
           EXIT.

       A-022-FIRST-TIME.
      *** SEND BACK INITIAL DEMO92 SCREEN (UPDATE)
           IF HSUB NOT = 0
               MOVE ERROR-MESSAGE (HSUB) TO DEMO92-ERR-MSG
           ELSE
               MOVE SPACES TO DEMO92-ERR-MSG.
           MOVE 'OTDEMO92' TO DEMO92-PROGRAM-NO.
           MOVE DEMO92-SCREEN TO TIOAIO.
           MOVE DEMO92-LTH    TO LL01-IN.
           CALL 'CBLTDLI' USING
               ISRT
               PCB-LT
               DC001TIO
               OTDEMO92.
           IF PCBSTAT = BB
                NEXT SENTENCE
           ELSE
                MOVE 3506 TO 9000-ABEND-CODE
                PERFORM C-099-ABEND THRU C-099-EXIT.
       A-022-EXIT.
           EXIT.

       A-030-PROCESS-TRAN.
      *** IF MENU SCREEN - DETERMINE WHICH FUNTION TO PROCESS
           IF DEMO91-PROGRAM-NO = 'OTDEMO91'
               PERFORM A-035-EDIT-MENU THRU A-035-EXIT
           ELSE
               PERFORM B-010-PROCESS-SCREEN2 THRU B-010-EXIT.
      *** OTHERWISE PROCESS UPDATE SCREEN
       A-030-EXIT.
           EXIT.

       A-035-EDIT-MENU.
      ***  PRESET EDIT FAILURE SWITCH TO OFF
           MOVE '0' TO EDIT-SWITCH.
           MOVE '0' TO FIRST-TIME.
      ***  GO PROCESS SCREEN2 IF THIS IS THE INDICATED BY
      ***  DEMO92-STATUS ^" "
           IF DEMO92-STATUS = '1'
               PERFORM B-010-PROCESS-SCREEN2 THRU B-010-EXIT
               GO TO A-035-EXIT.
      ***  EDIT MENU INPUT
           IF DEMO91-FUNCTION NOT = 'A' AND NOT = 'C' AND NOT = 'D'
                          AND NOT = 'a' AND NOT = 'c' AND NOT = 'd'
            AND NOT = 'I' AND NOT = 'M' AND NOT = 'E' AND NOT = 'P'
            AND NOT = 'i' AND NOT = 'm' AND NOT = 'e' AND NOT = 'p'
               MOVE '1' TO EDIT-SWITCH
               MOVE UMDAH TO DEMO91-FUNCTIONA
               MOVE CURSORPOS TO DEMO91-FUNCTIONC
               IF HSUB = 0
                   MOVE 2 TO HSUB.
           IF DEMO91-FUNCTION NOT = 'M' AND NOT = 'E' AND NOT = 'P'
                          AND NOT = 'm' AND NOT = 'e' AND NOT = 'p'
               IF DEMO91-TABLE-ID = SPACES
                   MOVE '1' TO EDIT-SWITCH
                   MOVE UMDAH TO DEMO91-TABLE-IDA
                   MOVE CURSORPOS TO DEMO91-TABLE-IDC
                   IF HSUB = 0
                       MOVE 4 TO HSUB.
      ***  IF EDITS FLOPPED RETURN MENU SCREEN
           IF EDIT-SWITCH = '1'
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO A-035-EXIT.
      ***  IF END FUNCTION INDICATED RETURN COMMON END SCREEN - END TASK
           IF DEMO91-FUNCTION = 'E' OR 'e'
               PERFORM C-100-RETURN THRU C-100-EXIT
               GO TO A-035-EXIT.
      ***  RETRIEVE TABLE HEADER RECORD
           PERFORM A-036-GET-HEADER THRU A-036-EXIT.
      ***  DEMO TO SEE IF HEADER RECORD IS REQUIRED - TRUE IF ADD ONLY
           IF DEMO91-FUNCTION NOT = 'A' AND NOT = 'a'
               IF DEMO-STATUS NOT = BB
                   MOVE '1' TO EDIT-SWITCH
                   MOVE CURSORPOS TO DEMO91-TABLE-IDC
                   MOVE UMDAH TO DEMO91-TABLE-IDA
                   IF HSUB = 0
                       MOVE 5 TO HSUB.
      ***  IF DEMO FAILS RETURN MENU
           IF EDIT-SWITCH = '1'
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO A-035-EXIT.
      ***  RESET IO AREA - START BUILDING UPDATE SCREEN (DEMO92)
           MOVE '1' TO FIRST-TIME.
           MOVE '1' TO DEMO92-STATUS.
           MOVE DEMO91-TABLE-ID TO DEMO92-TABLE-ID.
           MOVE DEMO91-FUNCTION TO DEMO92-PROCESS-IND.
           IF DEMO91-FUNCTION = 'A' OR 'a'
               MOVE 'ADD' TO DEMO92-TYPE.
           IF DEMO91-FUNCTION = 'C' OR 'c'
               MOVE 'CHANGE' TO DEMO92-TYPE.
           IF DEMO91-FUNCTION = 'D' OR 'd'
               MOVE 'DELETE' TO DEMO92-TYPE.
           IF DEMO91-FUNCTION = 'I' OR 'i'
               MOVE 'INQUIRY' TO DEMO92-TYPE.
      ***  IF ADD FUNCTION UNPROTECT DEMO92 HEADER FIELDS
           IF DEMO91-FUNCTION = 'A' OR 'a'
               PERFORM C-027-UNPROT-ELES THRU C-027-EXIT
                VARYING OSUB FROM 1 BY 1 UNTIL OSUB > 14
               IF DEMO-STATUS = BB
                   MOVE '1' TO EDIT-SWITCH
                   MOVE 6 TO HSUB
                   MOVE CURSORPOS TO DEMO91-TABLE-IDC
                   MOVE UMDAH TO DEMO91-TABLE-IDA
                   PERFORM A-020-FIRST-TIME THRU A-020-EXIT
                   GO TO A-035-EXIT
               ELSE
                   MOVE '1' TO DEMO92-ISRT-ROOT
                   MOVE CURSORPOS TO DEMO92-DESCC
           ELSE
               MOVE '0' TO DEMO92-ISRT-ROOT
               MOVE CURSORPOS TO DEMO92-FUNCC (1)
               PERFORM A-060-LOAD-DEMO92 THRU A-060-EXIT
               IF SCREEN2-FULL = '0'
                   COMPUTE ISUB = ISUB - 1
                   PERFORM C-024-UNPROT-ELES THRU C-024-EXIT
                    VARYING OSUB FROM ISUB BY 1 UNTIL OSUB > 14.
      ***  SEND UPDATE SCREEN LOADED WITH TABLE HEADER DATA
           IF DEMO91-FUNCTION = 'I' OR 'i'
               PERFORM C-025-PROT-INQ THRU C-025-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE LOW-VALUES TO DEMO92-FUNCC (1)
               MOVE CURSORPOS TO DEMO92-RETURNC
               MOVE PMDAN TO DEMO92-DESCA
               MOVE PMDAN TO DEMO92-ELE-KEY-CNTA
               MOVE PMDAN TO DEMO92-ELE-CHRA
               MOVE PMDAN TO DEMO92-ACT-DATEA
               MOVE PMDAN TO DEMO92-TBL-PROTA
               MOVE PMDDD TO DEMO92-TBL-PSWA
               MOVE PMDAN TO DEMO92-ELE-NUM-KEYA
               MOVE PMDAN TO DEMO92-ELE-NUM-VALA.
           IF DEMO91-FUNCTION = 'A' OR 'a'
               PERFORM C-026-PROT-ISRT THRU C-026-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14.
           IF DEMO91-FUNCTION = 'D' OR 'C' OR 'd' OR 'c'
               IF DEMOHDRS-PASSWORD-PROT = 'Y'
                   IF DEMO91-PASSWORD NOT = DEMOHDRS-PASSWORD
                       MOVE CURSORPOS TO DEMO91-PASSWORDC
                       MOVE 9 TO HSUB
                       MOVE '0' TO FIRST-TIME
                       PERFORM A-020-FIRST-TIME THRU A-020-EXIT
                       GO TO A-035-EXIT.
           IF DEMO91-FUNCTION = 'D' OR 'd'
               PERFORM C-025-PROT-INQ THRU C-025-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE CURSORPOS TO DEMO92-RETURNC
               MOVE PMDAN TO DEMO92-DESCA
               MOVE PMDAN TO DEMO92-ELE-KEY-CNTA
               MOVE PMDAN TO DEMO92-ELE-CHRA
               MOVE PMDAN TO DEMO92-ACT-DATEA
               MOVE PMDAN TO DEMO92-TBL-PROTA
               MOVE PMDDD TO DEMO92-TBL-PSWA
               MOVE PMDAN TO DEMO92-ELE-NUM-KEYA
               MOVE PMDAN TO DEMO92-ELE-NUM-VALA
               MOVE LOW-VALUES TO DEMO92-FUNCC (1)
               MOVE CURSORPOS TO DEMO92-RETURNC
               MOVE 8 TO HSUB.
           PERFORM A-022-FIRST-TIME THRU A-022-EXIT.
       A-035-EXIT.
           EXIT.

       A-036-GET-HEADER.
      ***  SET UP DEMOHDRS SSA
           MOVE DEMO91-TABLE-ID TO HDRS-FLDVALUE1.
           PERFORM A-045-GHU-HDRS THRU A-045-EXIT.
       A-036-EXIT.
           EXIT.

       A-045-GHU-HDRS.
      ***  DL/I CALL TO GHU DEMOHDRS SEGMENT
           MOVE '-' TO HDRS-COM1.
           CALL 'CBLTDLI' USING GHU
                                DEMO-PCB
                                DEMOHDRS
                                SSA-HDRS.
           IF DEMO-STATUS NOT = BB AND NOT = GE
               MOVE 3701 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
       A-045-EXIT.
           EXIT.

       A-060-LOAD-DEMO92.
      ***  ROUTINE TO PRE-LOAD DEMO92 WITH DEMOHDRS DATA
           MOVE DEMOHDRS-TABLE-DESCRIPTOR TO DEMO92-DESC.
           MOVE DEMOHDRS-KEY-CHAR-CNT TO DEMO92-ELE-KEY-CNT.
           MOVE DEMOHDRS-ELE-CHAR-CNT TO DEMO92-ELE-CHR.
           MOVE DEMOHDRS-LAST-ACT-DATE TO DATE-YMD9.
           MOVE DATE-YMD-YY TO GREG-YY.
           MOVE DATE-YMD-MM TO GREG-MM.
           MOVE DATE-YMD-DD TO GREG-DD.
           MOVE GREG-DATE   TO DEMO92-ACT-DATE.
           MOVE DEMOHDRS-PASSWORD-PROT TO DEMO92-TBL-PROT.
           MOVE DEMOHDRS-PASSWORD TO DEMO92-TBL-PSW.
           MOVE DEMOHDRS-NUMERIC-KEY TO DEMO92-ELE-NUM-KEY.
           MOVE DEMOHDRS-NUMERIC-ELE TO DEMO92-ELE-NUM-VAL.
           MOVE '0' TO FIRST-TIME.
      ***  EXIT SCREEN BUILD IF ADD OR DELETE PROCESSING
           IF DEMO91-FUNCTION = 'A' OR 'D' OR 'a' OR 'd'
               GO TO A-060-EXIT.
           MOVE '1' TO SCREEN2-FULL.
      ***  DEMO IF ELEMENT KEY HAS BEEN INPUT - IF SO POSITION DATA BASE
           IF DEMO91-ELES = SPACES
               MOVE ' =' TO ELES-RLO1
               MOVE ' ' TO ELES-COM1
               MOVE '1' TO FIRST-TIME
               PERFORM A-070-GNP-ELES THRU A-070-EXIT
               VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14 OR
               DEMO-STATUS NOT = BB
               PERFORM A-070-GNP-ELES THRU A-070-EXIT
           ELSE
               MOVE '-' TO ELES-COM1
               MOVE '=>' TO ELES-RLO1
               MOVE DEMO91-ELES TO ELES-FLDVALUE1
               MOVE '1' TO FIRST-TIME
               PERFORM A-075-GNP-ELES THRU A-075-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14 OR
               DEMO-STATUS NOT = BB.
       A-060-EXIT.
           EXIT.

       A-065-UNPROT-DEMO92.
      ***  UNPROTECT DEMOHDRS DATA FIELDS ON DEMO92 SCREEN - ADD
           MOVE PMDAN TO DEMO92-TABLE-IDA.
           MOVE UMDAN TO DEMO92-DESCA.
           MOVE UMDAN TO DEMO92-ELE-KEY-CNTA.
           MOVE UMDAN TO DEMO92-ELE-CHRA.
           MOVE UMDAN TO DEMO92-ACT-DATEA.
           MOVE UMDAN TO DEMO92-TBL-PROTA.
           MOVE UMDAD TO DEMO92-TBL-PSWA.
           MOVE UMDAN TO DEMO92-ELE-NUM-KEYA.
           MOVE UMDAN TO DEMO92-ELE-NUM-VALA.
       A-065-EXIT.
           EXIT.

       A-070-GNP-ELES.
      *** RETRIEVE DEMOELES SEGMENTS WITH UNQUALIFIED SSA
           MOVE ' ' TO ELES-COM1.
           CALL 'CBLTDLI' USING GNP
                                DEMO-PCB
                                DEMOELES
                                SSA-HDRS
                                SSA-ELES.
           IF ISUB = 15
               IF DEMO-STATUS  = GE
                   MOVE SPACES TO DEMO92-NEXT-KEY
                   GO TO A-070-EXIT
               ELSE
                   MOVE DEMOELES-KEY TO DEMO92-NEXT-KEY
                   GO TO A-070-EXIT.
           IF DEMO-STATUS  = GE
               MOVE '0' TO SCREEN2-FULL
               GO TO A-070-EXIT.
           IF DEMO-STATUS NOT = BB AND NOT = GE
               MOVE 3702 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
           PERFORM A-080-BUILD-ELES-DEMO92 THRU A-080-EXIT.
       A-070-EXIT.
           EXIT.

       A-075-GNP-ELES.
      *** RETRIEVE DEMOELES SEGMENTS WITH QUALIFIED SSA ON FIRST CALL
           CALL 'CBLTDLI' USING GNP
                                DEMO-PCB
                                DEMOELES
                                SSA-HDRS
                                SSA-ELES.
           IF FIRST-TIME = '1'
               MOVE '0' TO FIRST-TIME
               MOVE ' =' TO ELES-RLO1
               MOVE SPACE TO ELES-COM1.
           IF ISUB = 15
               IF DEMO-STATUS  = GE
                   MOVE SPACES TO DEMO92-NEXT-KEY
                   GO TO A-075-EXIT
               ELSE
                   MOVE DEMOELES-KEY TO DEMO92-NEXT-KEY
                   GO TO A-075-EXIT.
           IF DEMO-STATUS NOT = BB AND NOT = GE
               MOVE 3702 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
           IF DEMO-STATUS  = GE
               MOVE '0' TO SCREEN2-FULL
               MOVE SPACES TO DEMO92-NEXT-KEY
               GO TO A-075-EXIT.
           MOVE DEMOELES-KEY TO DEMO92-NEXT-KEY.
           PERFORM A-080-BUILD-ELES-DEMO92 THRU A-080-EXIT.
       A-075-EXIT.
           EXIT.

       A-080-BUILD-ELES-DEMO92.
      *** ROUTINE TO LOAD DEMO92 SCREEN WITH DEMOELES DATA
           MOVE DEMOELES-KEY TO DEMO92-LAST-KEY.
           MOVE DEMOELES-KEY TO DEMO92-ELE-KEY (ISUB).
           MOVE DEMOELES-ELE-DATA TO DEMO92-ELE-DATA (ISUB).
       A-080-EXIT.
           EXIT.

       B-010-PROCESS-SCREEN2.
      *** MAINLINE DRIVER FOR PROCESSING DEMO92 SCREEN - ADD,CHANGE,DEL
           MOVE LOW-VALUES TO DEMO91-REST.
      *** DEMO FOR LINE INPUT OF ADD FUNCTION - IF SO GO ADD
           IF DEMO92-PROCESS-IND = 'A' OR 'a'
               PERFORM B-020-ADD-DEMO92 THRU B-020-EXIT.
      *** DEMO FOR LINE INPUT OF CHANGE
           IF DEMO92-PROCESS-IND = 'C' OR 'c'
               PERFORM B-050-CHG THRU B-050-EXIT.
      *** DEMO FOR LINE INPUT OF DELETE - IF SO GO DELETE
           IF DEMO92-PROCESS-IND = 'D' OR 'd'
               PERFORM B-060-DEL THRU B-060-EXIT.
      *** DEMO FOR LINE INPUT OF INQUIRY
           IF DEMO92-PROCESS-IND = 'I' OR 'i'
               PERFORM B-080-DISPLAY THRU B-080-EXIT.
       B-010-EXIT.
           EXIT.

       B-020-ADD-DEMO92.
      *** ELEMENT LEVEL ADD MAINLINE
      *** MAKE SURE A CONTINUATION INDICATOR HAS BEEN INPUT BY USER
           IF DEMO92-CONT < 'A' AND
              DEMO92-RETURN < 'A' AND
              DEMO92-ABORT < 'A'
               MOVE 'X' TO DEMO92-CONT.
      *** GO DUPLICATE A SCREEN
           IF DEMO92-CONT = 'D'
               MOVE ' ' TO DEMO92-CONT
               PERFORM B-022-DUPLICATE THRU B-022-EXIT
                VARYING J FROM 2 BY 1 UNTIL J > 14
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               GO TO B-020-EXIT.
      *** IF CONTINUATION INDICATOR  = ABORT - RETURN TO MAIN MENU
           IF  DEMO92-ABORT NOT = SPACE AND NOT = '?'
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-020-EXIT.
      *** IF DEMOHDRS IS TO BE INSERTED - EDIT INPUT DATA
      *** IF ROOT EDIT FLOPS - RETURN SCREEN - EXIT
           IF DEMO92-ISRT-ROOT = '1'
               PERFORM B-029-EDIT-ROOT-DATA THRU B-029-EXIT
               IF EDIT-SWITCH = '1'
                   MOVE 1 TO ISUB
                   PERFORM C-027-UNPROT-ELES THRU C-027-EXIT
                    VARYING OSUB FROM ISUB BY 1 UNTIL OSUB > 14
                   PERFORM A-022-FIRST-TIME THRU A-022-EXIT
                   GO TO B-020-EXIT.
      *** ISRT DEMOHDRS SEGMENT
           IF DEMO92-ISRT-ROOT = '1'
               MOVE '0' TO DEMO92-ISRT-ROOT
               MOVE '1' TO DATE-SW
               PERFORM B-055-REPL-ACT-DATE THRU B-055-EXIT
               PERFORM B-025-ISRT-ROOT THRU B-025-EXIT
           ELSE
               MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1
               PERFORM A-045-GHU-HDRS THRU A-045-EXIT.
           IF DEMO92-ISRT-ROOT = '0'
               PERFORM B-029-EDIT-ROOT-DATA THRU B-029-EXIT
               IF EDIT-SWITCH = '1'
                   PERFORM A-022-FIRST-TIME THRU A-022-EXIT
                   GO TO B-020-EXIT
               ELSE
                   PERFORM B-026-REPL-ROOT THRU B-026-EXIT.
      *** EDIT & INST ELEMENT DATA INPUT (DEMOELES)
           PERFORM B-040-ADD THRU B-040-EXIT
            VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14.
      *** IF EDITS FLOPPED - RETURN SCREEN - EXIT
           IF SCREEN2-AGAIN = '1'
               MOVE 1 TO ISUB
               COMPUTE PSUB = PSUB + 1
               PERFORM C-027-UNPROT-ELES THRU C-027-EXIT
                VARYING OSUB FROM PSUB BY 1 UNTIL OSUB > 14
               PERFORM C-026-PROT-ISRT THRU C-026-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE BUBBLE-UP-AREA TO DEMO92-MATRIX
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               GO TO B-020-EXIT.
      *** DETERMINE CONTINUATION CRITERION
           IF DEMO92-RETURN NOT = SPACE OR DEMO92-ABORT NOT = SPACE
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-020-EXIT.
      *** CLEAN OUT DEMOELES MATRIX AREA ON SCREEN
           IF DEMO92-CONT NOT = SPACE
               MOVE LOW-VALUES TO DEMO92-MATRIX
               MOVE 1 TO ISUB
               PERFORM C-027-UNPROT-ELES THRU C-027-EXIT
                VARYING OSUB FROM ISUB BY 1 UNTIL OSUB > 14
               PERFORM C-026-PROT-ISRT THRU C-026-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14.
           MOVE CURSORPOS TO DEMO92-ELE-KEYC (1).
      *** RETURN THE DEMO92 SCREEN
           PERFORM A-022-FIRST-TIME THRU A-022-EXIT.
       B-020-EXIT.
           EXIT.

       B-022-DUPLICATE.
           MOVE UMDAN TO DEMO92-ELE-KEYA (J).
           MOVE LOW-VALUES TO DEMO92-ELE-KEYC(J).
           MOVE UMDAN TO DEMO92-ELE-DATAA (J).
           MOVE LOW-VALUES TO DEMO92-ELE-DATAC(J).
           MOVE UMDAN TO DEMO92-FUNCA (J).
           MOVE LOW-VALUES TO DEMO92-FUNCC(J).
           MOVE DEMO92-ELE-KEY (1) TO DEMO92-ELE-KEY (J).
           MOVE DEMO92-ELE-DATA (1) TO DEMO92-ELE-DATA (J).
           MOVE 'A' TO DEMO92-FUNC (J).
       B-022-EXIT.
           EXIT.

       B-025-ISRT-ROOT.
      *** ROUTINE TO INSERT DEMOHDRS SEGMENT
           MOVE DEMO92-TABLE-ID    TO DEMOHDRS-KEY.
           MOVE DEMO92-TABLE-ID    TO HDRS-FLDVALUE1.
           MOVE DEMO92-DESC        TO DEMOHDRS-TABLE-DESCRIPTOR.
           MOVE DEMO92-ELE-KEY-CNT TO DEMOHDRS-KEY-CHAR-CNT.
           MOVE DEMO92-ELE-CHR     TO DEMOHDRS-ELE-CHAR-CNT.
           MOVE DEMO92-TBL-PROT    TO DEMOHDRS-PASSWORD-PROT.
           MOVE DEMO92-TBL-PSW     TO DEMOHDRS-PASSWORD.
           MOVE DEMO92-ELE-NUM-KEY TO DEMOHDRS-NUMERIC-KEY.
           MOVE DEMO92-ELE-NUM-VAL TO DEMOHDRS-NUMERIC-ELE.
           MOVE SPACE TO HDRS-COM1.
           CALL 'CBLTDLI' USING ISRT
                                DEMO-PCB
                                DEMOHDRS
                                SSA-HDRS.
           IF DEMO-STATUS NOT = BB
               MOVE 3702 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
       B-025-EXIT.
           EXIT.

       B-026-REPL-ROOT.
           IF DATE-SW = '1'
               MOVE CURR-YMD9 TO DEMOHDRS-LAST-ACT-DATE.
      *** ROUTINE TO REPLACE DEMOHDRS SEGMENT
           MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1.
           PERFORM A-045-GHU-HDRS THRU A-045-EXIT.
            IF (DEMO92-DESC = DEMOHDRS-TABLE-DESCRIPTOR AND
                DEMO92-ELE-KEY-CNT = DEMOHDRS-KEY-CHAR-CNT AND
                 DEMO92-ELE-CHR = DEMOHDRS-ELE-CHAR-CNT AND
                   DEMO92-TBL-PROT = DEMOHDRS-PASSWORD-PROT AND
                    DEMO92-TBL-PSW = DEMOHDRS-PASSWORD AND
                     DEMO92-ELE-NUM-KEY = DEMOHDRS-NUMERIC-KEY AND
                      DEMO92-ELE-NUM-VAL = DEMOHDRS-NUMERIC-ELE) AND
                       DATE-SW = '0'
                       NEXT SENTENCE
                   ELSE
                       MOVE DEMO92-DESC TO DEMOHDRS-TABLE-DESCRIPTOR
                       MOVE DEMO92-ELE-KEY-CNT TO DEMOHDRS-KEY-CHAR-CNT
                       MOVE DEMO92-ELE-CHR TO DEMOHDRS-ELE-CHAR-CNT
                       MOVE CURR-YMD9   TO DEMOHDRS-LAST-ACT-DATE
                       MOVE CURR-YMD-YY TO GREG-YY
                       MOVE CURR-YMD-MM TO GREG-MM
                       MOVE CURR-YMD-DD TO GREG-DD
                       MOVE GREG-DATE   TO DEMO92-ACT-DATE
                       MOVE DEMO92-TBL-PROT TO DEMOHDRS-PASSWORD-PROT
                       MOVE DEMO92-TBL-PSW TO DEMOHDRS-PASSWORD
                       MOVE DEMO92-ELE-NUM-KEY TO DEMOHDRS-NUMERIC-KEY
                       MOVE DEMO92-ELE-NUM-VAL TO DEMOHDRS-NUMERIC-ELE
                       MOVE SPACE TO HDRS-COM1
                       CALL 'CBLTDLI' USING REPL
                                            DEMO-PCB
                                            DEMOHDRS
                                            SSA-HDRS
                       IF DEMO-STATUS NOT = BB
                           MOVE 3703 TO 9000-ABEND-CODE
                           PERFORM C-099-ABEND THRU C-099-EXIT.
       B-026-EXIT.
           EXIT.

       B-028-ISRT-ELES.
      *** ROUTINE TO INSERT DEMOELES SEGMENT
           IF DEMO92-ELE-KEY (ISUB) = SPACES
               GO TO B-028-EXIT.
           MOVE '-' TO HDRS-COM1.
           MOVE ' ' TO ELES-COM1.
           MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1.
           MOVE DEMO92-ELE-KEY (ISUB) TO DEMOELES-KEY.
           MOVE DEMO92-ELE-DATA (ISUB) TO DEMOELES-ELE-DATA.
           MOVE ' ' TO ELES-COM1.
           CALL 'CBLTDLI' USING ISRT
                                DEMO-PCB
                                DEMOELES
                                SSA-HDRS
                                SSA-ELES.
           IF DEMO-STATUS NOT = BB AND NOT = II
               MOVE 3704 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
       B-028-EXIT.
           EXIT.

       B-029-EDIT-ROOT-DATA.
      *** ROUTINE TO EDIT CRT INPUT OF DEMOHDRS DATA
           IF DEMO92-DESC = SPACES OR DEMO92-DESC = '?????'
               MOVE ALL '?' TO DEMO92-DESC
               MOVE '1' TO EDIT-SWITCH
               MOVE UMDAH TO DEMO92-DESCA
               MOVE CURSORPOS TO DEMO92-DESCC
               IF HSUB = 0
                   MOVE 4 TO HSUB.
           MOVE SPACE TO MSS-RETURN.
           MOVE 2 TO MSS-IN-LENGTH.
           CALL RGHTJUST USING
             MSS-RETURN
             DEMO92-ELE-KEY-CNT
             MSS-IN-LENGTH.
           IF MSS-RETURN = SPACE
               IF DEMO92-ELE-KEY-CNT < 1 OR > 20
                   MOVE UMDAH TO DEMO92-ELE-KEY-CNTA
                   MOVE CURSORPOS TO DEMO92-ELE-KEY-CNTC
                   MOVE '1' TO EDIT-SWITCH
                   IF HSUB = 0
                       MOVE 2 TO HSUB
                   ELSE
                       NEXT SENTENCE
               ELSE
                   NEXT SENTENCE
           ELSE
               MOVE UMDAH TO DEMO92-ELE-KEY-CNTA
               MOVE CURSORPOS TO DEMO92-ELE-KEY-CNTC
               MOVE '1' TO EDIT-SWITCH
               IF HSUB = 0
                   MOVE 1 TO HSUB.
           MOVE SPACE TO MSS-RETURN.
           MOVE 2 TO MSS-IN-LENGTH.
           CALL RGHTJUST USING
             MSS-RETURN
             DEMO92-ELE-CHR
             MSS-IN-LENGTH.
           IF MSS-RETURN = SPACE
               IF DEMO92-ELE-CHR > 50
                   MOVE UMDAH TO DEMO92-ELE-CHRA
                   MOVE CURSORPOS TO DEMO92-ELE-CHRC
                   MOVE '1' TO EDIT-SWITCH
                   IF HSUB = 0
                       MOVE 2 TO HSUB
                   ELSE
                       NEXT SENTENCE
               ELSE
                   NEXT SENTENCE
           ELSE
               MOVE UMDAH TO DEMO92-ELE-CHRA
               MOVE CURSORPOS TO DEMO92-ELE-CHRC
               MOVE '1' TO EDIT-SWITCH
               IF HSUB = 0
                   MOVE 1 TO HSUB.
           IF DEMO92-TBL-PROT NOT = 'Y' AND NOT = 'N' AND NOT = ' '
               MOVE '1' TO EDIT-SWITCH
               MOVE UMDAH TO DEMO92-TBL-PROTA
               MOVE CURSORPOS TO DEMO92-TBL-PROTC
               IF HSUB = 0
                   MOVE 2 TO HSUB.
           IF DEMO92-TBL-PROT = SPACES
               MOVE 'N' TO DEMO92-TBL-PROT.
           IF DEMO92-TBL-PROT = 'Y'
               IF DEMO92-TBL-PSW = SPACES
                   MOVE '1' TO EDIT-SWITCH
                   MOVE UMDAD TO DEMO92-TBL-PSWA
                   MOVE CURSORPOS TO DEMO92-TBL-PSWC
                   IF HSUB = 0
                       MOVE 4 TO HSUB.
           IF DEMO92-ELE-NUM-KEY NOT = 'Y' AND NOT = 'N' AND NOT = ' '
               MOVE '1' TO EDIT-SWITCH
               MOVE UMDAH TO DEMO92-ELE-NUM-KEYA
               MOVE CURSORPOS TO DEMO92-ELE-NUM-KEYC
               IF HSUB = 0
                   MOVE 2 TO HSUB.
           IF DEMO92-ELE-NUM-VAL NOT = 'Y' AND NOT = 'N' AND NOT = ' '
               MOVE '1' TO EDIT-SWITCH
               MOVE UMDAH TO DEMO92-ELE-NUM-VALA
               MOVE CURSORPOS TO DEMO92-ELE-NUM-VALC
               IF HSUB = 0
                   MOVE 2 TO HSUB.
           IF DEMO92-ISRT-ROOT = '1'
               GO TO B-029-EXIT.
           IF EDIT-SWITCH = '1'
               GO TO B-029-EXIT.
           IF DEMO92-ELE-KEY-CNT < DEMOHDRS-KEY-CHAR-CNT
               MOVE UMDAH TO DEMO92-ELE-KEY-CNTA
               MOVE CURSORPOS TO DEMO92-ELE-KEY-CNTC
               MOVE '1' TO EDIT-SWITCH
               IF HSUB = 0
                   MOVE 7 TO HSUB.
           IF DEMO92-ELE-CHR < DEMOHDRS-ELE-CHAR-CNT
               MOVE UMDAH TO DEMO92-ELE-CHRA
               MOVE CURSORPOS TO DEMO92-ELE-CHRC
               MOVE '1' TO EDIT-SWITCH
               IF HSUB = 0
                   MOVE 7 TO HSUB.
       B-029-EXIT.
           EXIT.

       B-040-ADD.
      *** ROUTINE TO EDIT CRT INPUT OF DEMOELES DATA
      *** SKIP THOSE LINE WHERE NO INPUT WAS KEYED
           MOVE UMDAN TO DEMO92-ELE-KEYA (ISUB).
           MOVE 'A' TO DEMO92-FUNC (ISUB).
           MOVE PMDAN TO DEMO92-FUNCA (ISUB).
           IF DEMO92-ELE-KEY (ISUB) = SPACES
               GO TO B-040-EXIT.
      *** EDIT INPUT KEY LENGTH AGAINST HEADER PARAMETER
           PERFORM B-056-CHECK-KEY-CNT THRU B-056-EXIT.
           IF LENGTH-ERROR = '1'
               MOVE '1' TO EDIT-SWITCH
               MOVE CURSORPOS TO DEMO92-ELE-KEYC (ISUB)
               MOVE UMDAH TO DEMO92-ELE-KEYA (ISUB)
               IF HSUB = 0
                   MOVE 3 TO HSUB.
      *** EDIT INPUT DATA LENGTH AGAINST HEADER PARAMETER
           PERFORM B-058-CHECK-CHR-CNT THRU B-058-EXIT.
           IF LENGTH-ERROR = '1'
               MOVE '1'       TO EDIT-SWITCH
               MOVE CURSORPOS TO DEMO92-ELE-DATAC (ISUB)
               MOVE UMDAH     TO DEMO92-ELE-DATAA (ISUB)
               IF HSUB = 0
                   MOVE 3 TO HSUB.
      *** IF NO EDIT FLOP WAS DETECTED - ISRT THE DEMOELES SEGMENT
           IF EDIT-SWITCH = '0'
              PERFORM B-028-ISRT-ELES THRU B-028-EXIT
               IF DEMO-STATUS = II
                   MOVE '1' TO EDIT-SWITCH
                   MOVE CURSORPOS TO DEMO92-FUNCC (ISUB)
                   MOVE UMDAH TO DEMO92-FUNCA (ISUB)
                   COMPUTE PSUB = PSUB + 1
                   MOVE CRT-LINE (ISUB) TO S-CRT-LINE (PSUB)
                   MOVE '1' TO SCREEN2-AGAIN
                   IF HSUB = 0
                       MOVE 6 TO HSUB
                   ELSE
                       NEXT SENTENCE
              ELSE
                   MOVE '0' TO EDIT-SWITCH
           ELSE
              COMPUTE PSUB = PSUB + 1
              MOVE CRT-LINE (ISUB) TO S-CRT-LINE (PSUB)
              MOVE '1' TO SCREEN2-AGAIN
              MOVE '0' TO EDIT-SWITCH.
       B-040-EXIT.
           EXIT.

       B-050-CHG.
      *** MAINLINE DRIVER FOR UPDATE FUNCTION
      *** GO DUPLICATE A SCREEN
           IF DEMO92-CONT = 'D'
               MOVE ' ' TO DEMO92-CONT
               PERFORM B-022-DUPLICATE THRU B-022-EXIT
                VARYING J FROM 2 BY 1 UNTIL J > 14
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               GO TO B-050-EXIT.
      *** DEMO CONTINUATION CRITERION
           MOVE '0' TO EDIT-SWITCH.
           MOVE '0' TO CHANGE-ADD-SW.
           MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1.
           PERFORM A-045-GHU-HDRS THRU A-045-EXIT.
           IF DEMO92-CONT < 'A' AND
              DEMO92-RETURN < 'A' AND
              DEMO92-ABORT < 'A'
               MOVE 'X' TO DEMO92-CONT.
           IF DEMO92-ABORT NOT = SPACE AND NOT = '?'
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-050-EXIT.
           PERFORM B-029-EDIT-ROOT-DATA THRU B-029-EXIT.
           IF EDIT-SWITCH = '1'
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               GO TO B-050-EXIT
           ELSE
               MOVE '0' TO DATE-SW
               PERFORM B-052-UPDATE THRU B-052-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               PERFORM B-055-REPL-ACT-DATE THRU B-055-EXIT
               PERFORM B-026-REPL-ROOT THRU B-026-EXIT.
      *** RETURN SCREEN IF AN ERROR WAS DETECTED
      *** YOU WILL HAVE PROBLEMS HERE
           IF SCREEN2-AGAIN = '1'
               MOVE 1 TO ISUB
               COMPUTE PSUB = PSUB + 1
               PERFORM C-024-UNPROT-ELES THRU C-024-EXIT
                VARYING OSUB FROM PSUB BY 1 UNTIL OSUB > 14
               MOVE BUBBLE-UP-AREA TO DEMO92-MATRIX
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               GO TO B-050-EXIT.
      *** ASCERTAIN CONTINUATION REQUEST
           IF DEMO92-RETURN NOT = SPACE OR DEMO92-ABORT NOT = SPACE
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-050-EXIT.
      *** CHANGE FUNCTION DETECTED LINE ADD(S) RETURN NULL SCREEN
           IF DEMO92-CONT NOT = SPACE
               IF CHANGE-ADD-SW = '1'
                   MOVE LOW-VALUES TO DEMO92-MATRIX
                   MOVE 1 TO ISUB
                   PERFORM C-027-UNPROT-ELES THRU C-027-EXIT
                    VARYING OSUB FROM ISUB BY 1 UNTIL OSUB > 14
                   PERFORM C-024-UNPROT-ELES THRU C-024-EXIT
                    VARYING OSUB FROM 1 BY 1 UNTIL OSUB > 14
                   MOVE CURSORPOS TO DEMO92-ELE-KEYC (1)
                   PERFORM A-022-FIRST-TIME THRU A-022-EXIT
                   GO TO B-050-EXIT.
      *** CONTINUE WAS SELECTED - UPDATE DATA BASE POSITION REQUEST
           IF DEMO92-CONT NOT = SPACE
               IF DEMO92-NEXT-KEY NOT = SPACES
                   MOVE DEMO92-NEXT-KEY TO DEMO92-LAST-KEY.
      *** CONTINUE WAS SELECTED - RETURN MORE DEMOELES SEGMENTS
           IF DEMO92-CONT NOT = SPACE
               MOVE LOW-VALUES TO DEMO92-MATRIX
               PERFORM C-023-PROT-ELES THRU C-023-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE '1' TO FIRST-TIME
               MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1
               PERFORM A-045-GHU-HDRS THRU A-045-EXIT
               MOVE DEMO92-NEXT-KEY TO ELES-FLDVALUE1
               MOVE '=>' TO ELES-RLO1
               MOVE '-' TO ELES-COM1
               MOVE '1' TO FIRST-TIME
                           SCREEN2-FULL
               PERFORM A-075-GNP-ELES THRU A-075-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14 OR
               DEMO-STATUS NOT = BB
               PERFORM A-075-GNP-ELES THRU A-075-EXIT
               PERFORM B-051-DASH-CHANGE THRU B-051-EXIT
           ELSE
               MOVE LOW-VALUES TO DEMO92-MATRIX
               MOVE SPACES TO DEMO92-NEXT-KEY
               PERFORM C-023-PROT-ELES THRU C-023-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE '1' TO FIRST-TIME
               MOVE CURSORPOS TO DEMO92-FUNCC (1)
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT.
      *** SEND BACK DEMO92 SCREEN
       B-050-EXIT.
           EXIT.

       B-051-DASH-CHANGE.
           IF DEMO-STATUS = GE OR GB
               MOVE SPACES TO DEMO92-NEXT-KEY
               MOVE CURSORPOS TO DEMO92-FUNCC (1)
           ELSE
               MOVE DEMOELES-KEY TO DEMO92-NEXT-KEY
               MOVE CURSORPOS TO DEMO92-FUNCC (1).
           IF SCREEN2-FULL = '0'
               COMPUTE ISUB = ISUB - 1
               PERFORM C-024-UNPROT-ELES THRU C-024-EXIT
                VARYING OSUB FROM ISUB BY 1 UNTIL OSUB > 14.
           PERFORM A-022-FIRST-TIME THRU A-022-EXIT.
       B-051-EXIT.
           EXIT.

       B-052-UPDATE.
      *** DETERMINE WHAT LINE INPUT FUNCTION TO INVOKE - ADD,CHG,DELETE
      *** SKIP THIS OCCURENCE IF INQUIRE FUNCTION INDICATOR PRESENT
           IF DEMO92-FUNC (ISUB) = 'I' OR 'i'
               GO TO B-052-EXIT.
      *** SKIP THIS OCCURENCE IF NO FUNCTION INDICATOR PRESENT
           IF DEMO92-FUNC (ISUB) = SPACES
               GO TO B-052-EXIT.
      *** SKIP THIS OCCURENCE IF NO KEY DATA PRESENT
           IF DEMO92-ELE-KEY (ISUB) = SPACES
               GO TO B-052-EXIT.
           IF DEMO92-FUNC (ISUB) = 'C' OR 'A' OR 'c' OR 'a'
               PERFORM B-056-CHECK-KEY-CNT THRU B-056-EXIT
               IF LENGTH-ERROR = '1'
                   MOVE '1' TO EDIT-SWITCH
                   MOVE CURSORPOS TO DEMO92-ELE-KEYC (ISUB)
                   MOVE UMDAH TO DEMO92-ELE-KEYA (ISUB)
                   IF HSUB = 0
                       MOVE 3 TO HSUB.
           IF DEMO92-FUNC (ISUB) = 'C' OR 'A' OR 'c' OR 'a'
               PERFORM B-058-CHECK-CHR-CNT THRU B-058-EXIT
               IF LENGTH-ERROR = '1'
                   MOVE '1' TO EDIT-SWITCH
                   MOVE CURSORPOS TO DEMO92-ELE-DATAC (ISUB)
                   MOVE UMDAH TO DEMO92-ELE-DATAA (ISUB)
                   IF HSUB = 0
                       MOVE 3 TO HSUB.
           IF DEMO92-FUNC (ISUB) NOT = 'A' AND NOT = 'C' AND NOT = 'D'
                             AND NOT = 'a' AND NOT = 'c' AND NOT = 'd'
               MOVE '1' TO EDIT-SWITCH
               MOVE CURSORPOS TO DEMO92-FUNCC (ISUB)
               MOVE UMDAH TO DEMO92-FUNCA (ISUB)
               IF HSUB = 0
                   MOVE 2 TO HSUB.
      *** DEMO TO SEE IF CRT INPUT DATA ERRORS - REJECT LINE
           IF EDIT-SWITCH = '1'
               COMPUTE PSUB = PSUB + 1
               MOVE CRT-LINE (ISUB) TO S-CRT-LINE (PSUB)
               MOVE '1' TO SCREEN2-AGAIN
               MOVE '0' TO EDIT-SWITCH
               GO TO B-052-EXIT.
      *** IF FUNCTION = 'C' -  PROCESS REPLACE/CHANGE
           IF DEMO92-FUNC (ISUB) = 'C' OR 'c'
               PERFORM B-054-REPL-DLET THRU B-054-EXIT.
      *** IF FUNCTION = 'D' - PROCESS DELETE REQUEST
           IF DEMO92-FUNC (ISUB) = 'D' OR 'd'
               PERFORM B-054-REPL-DLET THRU B-054-EXIT.
      *** IF FUNCTION = 'A' - PROCESS ISRT REQUEST
           IF DEMO92-FUNC (ISUB) = 'A' OR 'a'
               PERFORM B-053-ISRT THRU B-053-EXIT.
      *** REJECT THIS LINE INPUT - NO VALID FUNCTION INDICATOR
           IF EDIT-SWITCH = '1'
               COMPUTE PSUB = PSUB + 1
               MOVE CRT-LINE (ISUB) TO S-CRT-LINE (PSUB)
               MOVE '1' TO SCREEN2-AGAIN
               MOVE '0' TO EDIT-SWITCH
               GO TO B-052-EXIT.
       B-052-EXIT.
           EXIT.

       B-053-ISRT.
      *** BUILD SSA PARAMETERS
           MOVE '-' TO HDRS-COM1.
           MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1.
           MOVE DEMO92-ELE-KEY (ISUB) TO ELES-FLDVALUE1.
      *** ISSUE THE DEMOELES ISRT CALL
           PERFORM B-028-ISRT-ELES THRU B-028-EXIT.
           MOVE '1' TO CHANGE-ADD-SW.
           IF DEMO-STATUS NOT = II
               MOVE '1' TO DATE-SW.
           IF DEMO-STATUS = II
               MOVE '1' TO EDIT-SWITCH
               MOVE CURSORPOS TO DEMO92-FUNCC (ISUB)
               MOVE UMDAH TO DEMO92-FUNCA (ISUB)
               IF HSUB = 0
                   MOVE 6 TO HSUB.
       B-053-EXIT.
           EXIT.

       B-054-REPL-DLET.
      *** EDIT REPLACE/DELETE LINE INPUT
      *** ISSUE GHU FOR REPL/DLET
           MOVE '-' TO HDRS-COM1
           MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1
           MOVE DEMO92-ELE-KEY (ISUB) TO ELES-FLDVALUE1
           PERFORM B-070-GHU-ELES THRU B-070-EXIT
           IF DEMO-STATUS NOT = BB
               MOVE '1' TO EDIT-SWITCH
               MOVE CURSORPOS TO DEMO92-FUNCC (ISUB)
               MOVE UMDAH TO DEMO92-FUNCA (ISUB)
               IF HSUB = 0
                   MOVE 5 TO HSUB
                   GO TO B-054-EXIT
               ELSE
                   GO TO B-054-EXIT.
      *** ISSUE REPL FOR DEMOELES SEGMENT
           IF DEMO92-FUNC (ISUB) = 'C' OR 'c'
               MOVE '-' TO HDRS-COM1
               MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1
               MOVE DEMO92-ELE-KEY (ISUB) TO ELES-FLDVALUE1
               MOVE ' ' TO ELES-COM1
               MOVE DEMO92-ELE-DATA (ISUB) TO DEMOELES-ELE-DATA
               CALL 'CBLTDLI' USING REPL
                                    DEMO-PCB
                                    DEMOELES
               IF DEMO-STATUS = BB
                   MOVE '1' TO DATE-SW
               ELSE
                   IF DEMO-STATUS NOT = GE
                       MOVE 3801 TO 9000-ABEND-CODE
                       PERFORM C-099-ABEND THRU C-099-EXIT.
      *** ISSUE DLET FOR DEMOELES SEGMENT
           IF DEMO92-FUNC (ISUB) = 'D' OR 'd'
               MOVE '-' TO HDRS-COM1
               MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1
               MOVE DEMO92-ELE-KEY (ISUB) TO ELES-FLDVALUE1
               PERFORM B-070-GHU-ELES THRU B-070-EXIT
               MOVE ' ' TO ELES-COM1
               CALL 'CBLTDLI' USING DLET
                                    DEMO-PCB
                                    DEMOELES
               IF DEMO-STATUS = BB
                   MOVE '1' TO DATE-SW
               ELSE
                   MOVE 3751 TO 9000-ABEND-CODE
                   PERFORM C-099-ABEND THRU C-099-EXIT.
       B-054-EXIT.
           EXIT.

       B-055-REPL-ACT-DATE.
           IF DATE-SW = '0'
               GO TO B-055-EXIT.
           MOVE CURR-YMD9 TO DEMOHDRS-LAST-ACT-DATE.
       B-055-EXIT.
           EXIT.

       B-056-CHECK-KEY-CNT.
           MOVE '0' TO LENGTH-ERROR.
           IF DEMOHDRS-KEY-CHAR-CNT = 0
               GO TO B-056-EXIT.
           MOVE DEMO92-ELE-KEY (ISUB) TO GROUP-KEY-AREA.
           MOVE DEMOHDRS-KEY-CHAR-CNT TO OSUB.
           COMPUTE OSUB = OSUB + 1.
           PERFORM B-057-VALIDATE-KEY-LENGTH THRU B-057-EXIT
            VARYING WSUB FROM OSUB BY 1 UNTIL WSUB > 20.
       B-056-EXIT.
           EXIT.

       B-057-VALIDATE-KEY-LENGTH.
           IF KEY-MATRIX (WSUB) > SPACE
               MOVE '1' TO LENGTH-ERROR.
       B-057-EXIT.
           EXIT.

       B-058-CHECK-CHR-CNT.
           MOVE '0' TO LENGTH-ERROR.
           MOVE DEMO92-ELE-DATA (ISUB) TO GROUP-KEY-AREA.
           MOVE DEMOHDRS-ELE-CHAR-CNT TO OSUB.
           COMPUTE OSUB = OSUB + 1.
           PERFORM B-059-VALIDATE-ELE-LENGTH THRU B-059-EXIT
               VARYING WSUB FROM OSUB BY 1 UNTIL WSUB > 50.
       B-058-EXIT.
           EXIT.

       B-059-VALIDATE-ELE-LENGTH.
           IF KEY-MATRIX (WSUB) > SPACE
               MOVE '1' TO LENGTH-ERROR.
       B-059-EXIT.
           EXIT.

       B-060-DEL.
      *** MAINLINE DRIVER FOR DELETE OF ENTIRE DEMOHDRS SEGMENT
      *** CHECK CONTINUATION CRITERIA
           IF DEMO92-CONT < 'A' AND
              DEMO92-RETURN < 'A' AND
              DEMO92-ABORT < 'A'
               MOVE 'X' TO DEMO92-CONT.
      *** IF USER INPUT ABORT COMMAND - REJECT TRANS RETURN TO MAIN MENU
           IF DEMO92-ABORT NOT = SPACE AND NOT = '?'
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-060-EXIT.
           IF DEMO92-RETURN NOT = 'D'
               MOVE CURSORPOS TO DEMO92-RETURNC
               MOVE 8 TO HSUB
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               GO TO B-060-EXIT.
           MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1.
      *** SATISFY DL/I HOLD CALL REQUIREMENT
           PERFORM A-045-GHU-HDRS THRU A-045-EXIT.
           MOVE ' ' TO HDRS-COM1.
      *** DELETE DEMOHDRS SEGMENT AND ALL CHILDREN
           CALL 'CBLTDLI' USING DLET
                                DEMO-PCB
                                DEMOHDRS.
           IF DEMO-STATUS NOT = BB AND NOT = GE
               MOVE 3901 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
           MOVE 'X' TO DEMO92-RETURN.
           IF DEMO92-RETURN NOT = SPACE OR DEMO92-ABORT NOT = SPACE
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-060-EXIT.
       B-060-EXIT.
           EXIT.

       B-070-GHU-ELES.
      *** DL/I ROUTINE TO RETRIVE WITH HOLD DEMOELES SEGMENTS
           MOVE '-' TO ELES-COM1.
           CALL 'CBLTDLI' USING GHU
                                DEMO-PCB
                                DEMOELES
                                SSA-HDRS
                                SSA-ELES.
           IF DEMO-STATUS NOT = BB AND NOT = GE
               MOVE 3702 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
       B-070-EXIT.
           EXIT.

       B-080-DISPLAY.
      *** MAINLINE DRIVER FOR DISPLAY FUNCTION
      *** DEMO CONTINUATION CRITERION
           IF DEMO92-CONT < 'A' AND
              DEMO92-RETURN < 'A' AND
              DEMO92-ABORT < 'A'
               MOVE 'X' TO DEMO92-CONT.
           IF DEMO92-ABORT NOT = SPACE AND NOT = '?'
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-080-EXIT.
           MOVE PMDAN TO DEMO92-DESCA.
           MOVE PMDAN TO DEMO92-ELE-KEY-CNTA.
           MOVE PMDAN TO DEMO92-ELE-CHRA.
           MOVE PMDAN TO DEMO92-TBL-PROTA.
           MOVE PMDAN TO DEMO92-ACT-DATEA.
           MOVE UMDAD TO DEMO92-TBL-PSWA.
           MOVE PMDAN TO DEMO92-ELE-NUM-KEYA.
           MOVE PMDAN TO DEMO92-ELE-NUM-VALA.
      *** ASCERTAIN CONTINUATION REQUEST
           IF DEMO92-RETURN NOT = SPACE OR DEMO92-ABORT NOT = SPACE
               MOVE '1' TO FIRST-TIME
               PERFORM A-020-FIRST-TIME THRU A-020-EXIT
               GO TO B-080-EXIT.
      *** CONTINUE WAS SELECTED - UPDATE DATA BASE POSITION REQUEST
           IF DEMO92-CONT NOT = SPACE
               IF DEMO92-NEXT-KEY NOT = SPACES
                   MOVE DEMO92-NEXT-KEY TO DEMO92-LAST-KEY.
      *** CONTINUE WAS SELECTED - RETURN MORE DEMOELES SEGMENTS
           IF DEMO92-CONT NOT = SPACE
               MOVE PMDAN TO DEMO92-TABLE-IDA
               MOVE PMDAN TO DEMO92-DESCA
               MOVE PMDAN TO DEMO92-ELE-KEY-CNTA
               MOVE PMDAN TO DEMO92-ELE-CHRA
               MOVE PMDAN TO DEMO92-ACT-DATEA
               MOVE PMDAN TO DEMO92-TBL-PROTA
               MOVE PMDDD TO DEMO92-TBL-PSWA
               MOVE PMDAN TO DEMO92-ELE-NUM-KEYA
               MOVE PMDAN TO DEMO92-ELE-NUM-VALA
               MOVE LOW-VALUES TO DEMO92-MATRIX
               PERFORM C-025-PROT-INQ THRU C-025-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE '1' TO FIRST-TIME
               MOVE DEMO92-TABLE-ID TO HDRS-FLDVALUE1
               PERFORM A-045-GHU-HDRS THRU A-045-EXIT
               MOVE DEMO92-NEXT-KEY TO ELES-FLDVALUE1
               MOVE '=>' TO ELES-RLO1
               MOVE '1' TO FIRST-TIME
               MOVE '-' TO ELES-COM1
               PERFORM A-075-GNP-ELES THRU A-075-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14 OR
               DEMO-STATUS NOT = BB
               PERFORM A-075-GNP-ELES THRU A-075-EXIT
               MOVE CURSORPOS TO DEMO92-RETURNC
               IF DEMO-STATUS = GE OR GB
                   MOVE SPACES TO DEMO92-NEXT-KEY
                   PERFORM A-022-FIRST-TIME THRU A-022-EXIT
               ELSE
                   MOVE DEMOELES-KEY TO DEMO92-NEXT-KEY
                   PERFORM A-022-FIRST-TIME THRU A-022-EXIT
           ELSE
               MOVE LOW-VALUES TO DEMO92-MATRIX
               MOVE SPACES TO DEMO92-LAST-KEY
               MOVE SPACES TO DEMO92-NEXT-KEY
               PERFORM C-023-PROT-ELES THRU C-023-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               PERFORM C-025-PROT-INQ THRU C-025-EXIT
                VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14
               MOVE '1' TO FIRST-TIME
               MOVE LOW-VALUES TO DEMO92-FUNCC (1)
               MOVE CURSORPOS TO DEMO92-RETURNC
               PERFORM A-022-FIRST-TIME THRU A-022-EXIT.
       B-080-EXIT.
           EXIT.

       C-010-INITIALIZE.
      *** INITIALIZATION ROUTINE - INSURE RE-ENTRABILITY
           MOVE '1' TO FIRST-TIME.
           MOVE '1' TO FIRST-INSERT.
           MOVE '1' TO DATA-PRESENT.
           MOVE '0' TO DATE-SW.
           MOVE SPACES TO DEMO91-SCREEN.
           MOVE SPACES TO DEMO92-SCREEN.
           MOVE SPACES TO TIOAIO.
           MOVE LOW-VALUES TO BUBBLE-UP-AREA.
           MOVE '0' TO EDIT-SWITCH.
           MOVE '0' TO REPL-SW.
           MOVE '0' TO CHANGE-ADD-SW.
           MOVE '0' TO EOP-SW.
           MOVE '0' TO LENGTH-ERROR.
           MOVE '0' TO SCREEN2-AGAIN.
           MOVE '1' TO SCREEN2-FULL.
           MOVE '0' TO EOP-SW.
           MOVE ' ' TO DEMO92-STATUS.
           ACCEPT CURR-YMD FROM DATE.
           MOVE ZERO TO HSUB.
           MOVE ZERO TO PSUB.
           MOVE ZERO TO ISUB.
           MOVE ZERO TO OSUB.
           MOVE ZERO TO WSUB.
       C-010-EXIT.
           EXIT.

       C-020-GET-MESSAGE.
      *** IO-PCB MESSAGE PROCESSING - INPUT
           CALL 'CBLTDLI' USING
               GU
               PCB-LT
               DC001TIO.
           IF PCBSTAT NOT = BB AND NOT = QC AND NOT = QD
               MOVE 3514 TO 9000-ABEND-CODE
               PERFORM C-099-ABEND THRU C-099-EXIT.
           MOVE LOW-VALUES TO DEMO91-SCREEN.
           MOVE LOW-VALUES TO DEMO92-SCREEN.
           STRING TIOAIO(1:LL01-IN - 4) DELIMITED BY SIZE
               INTO DEMO91-SCREEN.
           STRING TIOAIO(1:LL01-IN - 4) DELIMITED BY SIZE
               INTO DEMO92-SCREEN.
           PERFORM C-021-FORMAT-NULL-SCREEN THRU C-021-EXIT.
           PERFORM C-022-FORMAT-NULL-SCREEN THRU C-022-EXIT.
           MOVE CRT-LENGTH TO LL01-IN.
       C-020-EXIT.
           EXIT.

       C-021-FORMAT-NULL-SCREEN.
      *** SCREEN HANDLING FOR DYNAMIC ATTRIBUTE MODIFICATION
           MOVE LOW-VALUES TO DEMO91-FUNCTIONC
                              DEMO91-PASSWORDC
                              DEMO91-TABLE-IDC
                              DEMO91-ELESC.
           MOVE UMDAN TO DEMO91-FUNCTIONA
                         DEMO91-TABLE-IDA
                         DEMO91-ELESA.
           MOVE UMDAD TO DEMO91-PASSWORDA.
       C-021-EXIT.
           EXIT.

       C-022-FORMAT-NULL-SCREEN.
      *** SCREEN HANDLING FOR DYNAMIC ATTRIBUTE MODIFICATION
           MOVE PMDDD TO DEMO92-LAST-KEYA.
           MOVE UMDAN TO DEMO92-NEXT-KEYA.
           MOVE LOW-VALUES TO
               DEMO92-TYPEC
               DEMO92-TABLE-IDC
               DEMO92-DESCC
               DEMO92-LAST-KEYC
               DEMO92-ELE-KEY-CNTC
               DEMO92-ELE-CHRC
               DEMO92-ACT-DATEC
               DEMO92-TBL-PROTC
               DEMO92-TBL-PSWC
               DEMO92-ELE-NUM-KEYC
               DEMO92-ELE-NUM-VALC
               DEMO92-RETURNC
               DEMO92-CONTC
               DEMO92-NEXT-KEYC
               DEMO92-ABORTC.
           MOVE UMDAN TO
               DEMO92-DESCA
               DEMO92-ELE-KEY-CNTA
               DEMO92-ELE-CHRA
               DEMO92-ACT-DATEA
               DEMO92-TBL-PROTA
               DEMO92-TBL-PSWA
               DEMO92-ELE-NUM-KEYA
               DEMO92-ELE-NUM-VALA
               DEMO92-RETURNA
               DEMO92-CONTA
               DEMO92-ABORTA.
           MOVE PMDAN TO
                         DEMO92-TYPEA
                         DEMO92-ACT-DATEA
                         DEMO92-TABLE-IDA
                         DEMO92-ELE-NUM-KEYA
                         DEMO92-ELE-NUM-VALA.
           MOVE PMDDD TO DEMO92-LAST-KEYA.
           MOVE UMDAD TO DEMO92-TBL-PSWA.
           PERFORM C-023-PROT-ELES THRU C-023-EXIT
            VARYING ISUB FROM 1 BY 1 UNTIL ISUB > 14.
           MOVE CRT-LENGTH TO LL01-IN.
       C-022-EXIT.
           EXIT.

       C-023-PROT-ELES.
      *** SCREEN HANDLING FOR DYNAMIC ATTRIBUTE MODIFICATION - ARRAY
           MOVE LOW-VALUES TO
               DEMO92-FUNCC (ISUB)
               DEMO92-ELE-KEYC (ISUB)
               DEMO92-ELE-DATAC (ISUB)
               S-M2-FUNCC (ISUB)
               S-M2-ELE-KEYC (ISUB)
               S-M2-ELE-DATAC (ISUB).
           MOVE PMDAN TO
               DEMO92-ELE-KEYA (ISUB)
               S-M2-ELE-KEYA (ISUB).
           MOVE UMDAN TO DEMO92-ELE-DATAA (ISUB).
           MOVE UMDAN TO S-M2-ELE-DATAA (ISUB).
           MOVE UMDAN TO DEMO92-FUNCA (ISUB).
           MOVE UMDAN TO S-M2-FUNCA (ISUB).
       C-023-EXIT.
           EXIT.

       C-024-UNPROT-ELES.
      *** SCREEN HANDLING FOR DYNAMIC ATTRIBUTE MODIFICATION - ARRAY
           MOVE UMDAN TO
               DEMO92-FUNCA (OSUB)
               DEMO92-ELE-KEYA (OSUB)
               DEMO92-ELE-DATAA (OSUB)
               S-M2-FUNCA (OSUB)
               S-M2-ELE-KEYA (OSUB)
               S-M2-ELE-DATAA (OSUB).
           MOVE '-' TO DEMO92-FUNC (OSUB)
                       S-M2-FUNC (OSUB).
       C-024-EXIT.
           EXIT.

       C-025-PROT-INQ.
           MOVE PMDAN TO
               DEMO92-FUNCA (ISUB)
               DEMO92-ELE-KEYA (ISUB)
               DEMO92-ELE-DATAA (ISUB)
               S-M2-FUNCA (ISUB)
               S-M2-ELE-KEYA (ISUB)
               S-M2-ELE-DATAA (ISUB).
           MOVE SPACES TO DEMO92-FUNC (ISUB).
       C-025-EXIT.
           EXIT.
       C-026-PROT-ISRT.
           MOVE PMDAN TO
               DEMO92-FUNCA (ISUB)
               S-M2-FUNCA (ISUB).
       C-026-EXIT.
           EXIT.

       C-027-UNPROT-ELES.
      *** SCREEN HANDLING FOR DYNAMIC ATTRIBUTE MODIFICATION - ARRAY
           MOVE UMDAN TO
               DEMO92-ELE-KEYA (OSUB)
               DEMO92-ELE-DATAA (OSUB)
               S-M2-ELE-KEYA (OSUB)
               S-M2-ELE-DATAA (OSUB).
           MOVE 'A' TO DEMO92-FUNC (OSUB)
                       S-M2-FUNC (OSUB).
           MOVE PMDAN TO
               S-M2-FUNCA (OSUB)
               DEMO92-FUNCA (OSUB).
       C-027-EXIT.
           EXIT.

       C-099-ABEND.
      * SETUP ENDING MESSAGES (BEFORE ROLB CALL CHGS STATUS)
           MOVE SPACES                 TO END-LINE3.
           STRING 'TRANCODE MFDEMO ABENDED WITH USER CODE: '
                  9000-ABEND-CODE
               DELIMITED BY SIZE     INTO END-LINE3.
           STRING 'IO PCB STATUS: '
                  PCBSTAT
               DELIMITED BY SIZE     INTO END-LINE4.
           STRING 'DB DEMO03DD PCB STATUS: '
                  DEMO-STATUS
               DELIMITED BY SIZE     INTO END-LINE5.
      *** BACKOUT ANY PENDING UPDATES
           CALL 'CBLTDLI' USING ROLB
                                PCB-LT.
      *** SEND INFORMATIONAL ENDING SCREEN
           MOVE COMMON-END-SCREEN TO TIOAIO.
           MOVE DEMO90-LTH        TO LL01-IN.
           CALL 'CBLTDLI' USING ISRT
                                PCB-LT
                                DC001TIO
                                OTDEMO90.
      * IGNORE ANY FAILED STATUS CODE ON THIS INSERT - JUST RETURN
           GOBACK.
       C-099-EXIT.
           EXIT.

       C-100-RETURN.
           MOVE COMMON-END-SCREEN TO TIOAIO.
           MOVE DEMO90-LTH        TO LL01-IN.
           CALL 'CBLTDLI' USING
            ISRT
            PCB-LT
            DC001TIO
            OTDEMO90
            IF PCBSTAT = BB
                 NEXT SENTENCE
            ELSE
                 MOVE 3555 TO 9000-ABEND-CODE
                 PERFORM C-099-ABEND THRU C-099-EXIT.
      *** MAINLINE ROUTINE TO END PROCESSING
           GOBACK.
       C-100-EXIT.
           EXIT.
