       IDENTIFICATION DIVISION.
       PROGRAM-ID. RGHTJUST.
      *
      * Copyright (c) Micro Focus 1991-2012. All rights reserved. The 
      * software and information contained herein are proprietary to,
      * and comprise valuable trade secrets of, Micro Focus , which 
      * intends to preserve as trade secrets such software and 
      * information. This software is an unpublished copyright of 
      * Micro Focus and may not be used, copied, transmitted, or 
      * stored in any manner.  This software and information or any 
      * other copies thereof may not be provided or otherwise made 
      * available to any other person.
      *
       ENVIRONMENT DIVISION.
       DATA DIVISION.

       WORKING-STORAGE SECTION.
       77  EOD-DATA       PIC  X(01) VALUE '0'.
       77  I              PIC S9(04) COMP.
       77  J              PIC  9(04) COMP.
       77  K              PIC  9(04) COMP.
       77  L              PIC  9(04) COMP.
       01  SWAP-AREA.
           03  SW OCCURS 15 TIMES PIC X(01).

       LINKAGE SECTION.
       01  MSS-RETURN                PIC X(01).
       01  MSS-IN-DATA.
           05 ND OCCURS 1 TO 15 TIMES DEPENDING ON MSS-IN-LEN PIC X(01).
       01  MSS-IN-LEN                PIC 9(08) COMP.

       PROCEDURE DIVISION       USING MSS-RETURN
                                      MSS-IN-DATA
                                      MSS-IN-LEN.
           MOVE SPACE              TO MSS-RETURN.
           MOVE MSS-IN-LEN         TO L.
           MOVE 0                  TO J K.
           MOVE '0'                TO EOD-DATA.
           PERFORM A-010-ROTATE  THRU A-010-EXIT
               VARYING I         FROM L BY -1
               UNTIL (EOD-DATA = '1' OR I = 0).
           IF K NOT = 0
               COMPUTE J = (L - K) + 1
               PERFORM A-020-ISRT-NUMERIC THRU A-020-EXIT
                   VARYING I     FROM 1 BY 1
                   UNTIL I > K.
           PERFORM A-030-UPDATE  THRU A-030-EXIT
               VARYING I         FROM 1 BY 1
               UNTIL I > MSS-IN-LEN.
           GOBACK.

       A-010-ROTATE.
           IF ND (I) > ' '
               MOVE I              TO K
               MOVE '1'            TO EOD-DATA
               GO TO A-010-EXIT.
           ADD 1                   TO J.
           MOVE '0'                TO SW (J).
       A-010-EXIT.
           EXIT.

       A-020-ISRT-NUMERIC.
           MOVE ND (I)             TO SW (J).
           ADD 1                   TO J.
       A-020-EXIT.
           EXIT.

       A-030-UPDATE.
           IF SW (I) < '0' OR SW (I) > '9'
               MOVE '1'            TO MSS-RETURN.
           MOVE SW (I)             TO ND (I).
       A-030-EXIT.
           EXIT.
